// // // // // // // // // // // // // // // // // // // //
//	
//	Effector
//	
//	created Apr/13/98 by Andreas Warnke
//	last mod Mai/17/98 by Andreas Warnke
//	



// // // // // // // // // // // // // // // // // // // //
//	
//	#include
//

#include <Be.h>
#include "ConnectionData.h"
#include "Effector.h"
#include "AsciiKette.h"
#include "GlobalVariables.h"



// // // // // // // // // // // // // // // // // // // //
//	
//	Constructor
//

Effector :: Effector ()
{
};



// // // // // // // // // // // // // // // // // // // //
//	
//	Destructor
//

Effector :: ~Effector ()
{
};



// // // // // // // // // // // // // // // // // // // //
//	
//	Send Login Message:
//

bool Effector :: Login (
	const char * inName,
	const char * inPassword,
	const char * inReadOnlyPassword )
{
	if ( ( inName == NULL ) || ( inPassword == NULL ) )
		//	Missing parameters.
		return false;
		
	if ( LoggedIn )
		//	Already logged in.
		return false;
		
	//	Look for Server:
	status_t sError;
	TheServer = BMessenger (
		eServerMIME , -1, &sError );
	if ( sError < B_NO_ERROR )
	{
		//	Server is not running.
		//	Launch Server:
		be_roster -> Launch ( eServerMIME );
		snooze ( 100000 );	
		//	Look for Server:
		TheServer = BMessenger
			( eServerMIME , -1, &sError );
		if ( sError < B_NO_ERROR )
			//	Server is still not running.
			return false;
	};

	//	Server exists.

	//	Copy Name and Password from Parameters to Object:
	DeleteNameAndPasswords ();
	TheName = Concat ( inName, NULL );
	ThePassword = Concat ( inPassword, NULL );
	if ( ( TheName == NULL ) || ( ThePassword == NULL ) )
		//	Out of memory.
		return false;
	if ( inReadOnlyPassword != NULL )
	{
		//	ReadOnly - Password exists.
		//	Copy ReadOnly - Password:
		TheReadOnlyPassword = Concat ( inReadOnlyPassword, NULL );
		if ( TheReadOnlyPassword == NULL )
			//	Out of memory.
			return false;
	};
	
	//	Create Login Message:
	BMessage * sLoginMessage = new BMessage ( eInterApplicationMessage );
	if ( sLoginMessage == NULL )
		//	Out of memory.
		//	newer C++ compilers throw an exeption and abort the program.
		return false;
	sLoginMessage -> AddString ( "Type", "login" );
	sLoginMessage -> AddString ( "ClientName", inName );
	sLoginMessage -> AddString ( "Password", inPassword );
	sLoginMessage -> AddInt32 ( "Version", 1 );
	if ( inReadOnlyPassword != NULL )
		sLoginMessage -> AddString ( "ReadOnlyPassword", inReadOnlyPassword );
	
	//	Send Message! Dont forget to specify the correct reply-handler (this)!	
	if ( TheServer . SendMessage ( sLoginMessage, this ) < B_NO_ERROR )
	{
		//	Message was not delivered.
		delete sLoginMessage;
		return false;
	};
	
	//	free occupied memory:
	delete sLoginMessage;
	
	//	Login message sent successfully.
	return true;
};



// // // // // // // // // // // // // // // // // // // //
//	
//	Move
//

bool Effector :: Move (
	unsigned int inObjectID,
	int inToX,
	int inToY )
{
	//	Logged in?
	if ( ( ! LoggedIn ) || ( GameFinished ) )
		return false;

	//	Create Move Message:
	BMessage sMoveMessage ( eInterApplicationMessage );
	sMoveMessage . AddString ( "Type", "turn" );
	sMoveMessage . AddString ( "ClientName", TheName );
	sMoveMessage . AddString ( "Password", ThePassword );
	sMoveMessage . AddInt32 ( "ID", inObjectID );
	sMoveMessage . AddString ( "Action", "move" );
	sMoveMessage . AddInt32 ( "MoveToX", inToX );
	sMoveMessage . AddInt32 ( "MoveToY", inToY );
		
	//	Send Move-Message:
	if ( TheServer . SendMessage ( & sMoveMessage ) < B_NO_ERROR )
	{
		//	Server doesn't exist.
		ServerDied ();
		return false;
	};
	
	//	ready.
	return true;
};



//	
//	The End.
//	
// // // // // // // // // // // // // // // // // // // //